﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using ExcelDna.Integration.Extensibility;
using ExcelDna.Integration;
using ExcelDna.Integration.CustomUI;
using System.Runtime.InteropServices;
using System.Windows.Forms;

// some cryptic stuff to register the addIn in Excel
public class AddInRoot : IExcelAddIn 
  {  
   public void AutoOpen() 
     {  
      try 
       { var com_addin = new AddInComRoot();
         com_addin.GetType().InvokeMember("DnaLibrary", BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.SetProperty, null, com_addin, new object[] { DnaLibrary.CurrentLibrary });
         ExcelComAddInHelper.LoadComAddIn(com_addin);
       } 
      catch (Exception e) 
       {   MessageBox.Show("Error loading COM AddIn: " + e.ToString());
       }
     }
       
     public void AutoClose() { }
  }


[ComVisible(true)]
public class AddInComRoot : ExcelDna.Integration.CustomUI.ExcelComAddIn 
  {  // : IDTExtensibility2, ie COM "AddIn".ExcelDNA finds this by magic.
     MyAddinObject _helper;
      
    public AddInComRoot() {}
        
    public override void OnConnection(object Application,
    ext_ConnectMode ConnectMode, object AddInInst, ref Array custom) 
      {  _helper = new MyAddinObject();

         AddInInst.GetType().InvokeMember("Object",
                BindingFlags.Public | BindingFlags.Instance | BindingFlags.SetProperty, 
                null, 
                AddInInst, 
                new object[] { _helper });
       }
     public override void OnDisconnection(ext_DisconnectMode RemoveMode, ref Array custom) {}
     public override void OnAddInsUpdate(ref Array custom) {}
     public override void OnStartupComplete(ref Array custom) {}
     public override void OnBeginShutdown(ref Array custom) {}
    }

// the interresting stuff is here

[ComVisible(true)]
public class MyAddinObject 
  {   // This becomes the VBA addin.Object
      string lasterrmsg = "";
      YTemperature tsensor;
      bool initdone = false;

      // int the Yoctopuce APi and search for a tempature sensor
      public bool Init()
      {  
        if (initdone) return true;
        if (YAPI.RegisterHub("usb",ref lasterrmsg) == YAPI.SUCCESS)
         {
            tsensor = YTemperature.FirstTemperature();
            if (tsensor == null)
            {
              lasterrmsg = "No temperature sensor found";
              return false;
            }
            initdone = true;
            return true;
         }
         return false;
      }

      // return a last error enountered error message
      public string getLastError()
      {
        return lasterrmsg;
      }

      // return the found temperature sensor  name 
      public string getSensorName()
      {
        if (tsensor == null) return "invalid temp sensor";
        return tsensor.describe();
      }

      // return the value reportured by the sensor
      public string getTemperature()
      {
        if (tsensor == null) return "invalid temp sensor";
          return Convert.ToString(tsensor.get_currentValue());
      }
   }

